/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.items.stacks.builders;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.TreeMap;
import net.impactdev.impactor.api.items.builders.AbstractStackBuilder;
import net.impactdev.impactor.api.items.builders.provided.BookStackBuilder;
import net.impactdev.impactor.api.items.extensions.BookStack;
import net.impactdev.impactor.minecraft.items.stacks.providers.ImpactorBookStack;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Range;

public class ImpactorBookStackBuilder
extends AbstractStackBuilder<BookStack, BookStackBuilder>
implements BookStackBuilder {
    public BookStack.BookType type = BookStack.BookType.WRITTEN;
    public String author;
    public BookStack.Generation generation = BookStack.Generation.ORIGINAL;
    public TreeMap<Integer, Component> pages = Maps.newTreeMap();

    @Override
    public BookStackBuilder type(BookStack.BookType type) {
        this.type = type;
        return this;
    }

    @Override
    public BookStackBuilder title(Component title) {
        return (BookStackBuilder)super.title(title);
    }

    @Override
    public BookStackBuilder author(String author) {
        this.author = author;
        return this;
    }

    @Override
    public BookStackBuilder generation(BookStack.Generation generation) {
        this.generation = generation;
        return this;
    }

    @Override
    public BookStackBuilder page(@Range(from=1L, to=50L) int page, Component content) {
        this.pages.put(page, content);
        return this;
    }

    @Override
    public BookStackBuilder pages(Component ... contents) {
        int page = 1;
        for (Component content : contents) {
            this.pages.put(page++, content);
        }
        return this;
    }

    @Override
    public BookStackBuilder pages(Collection<Component> contents) {
        int page = 1;
        for (Component content : contents) {
            this.pages.put(page++, content);
        }
        return this;
    }

    @Override
    public BookStack build() {
        return new ImpactorBookStack(this);
    }
}

